# CJK LCD Font test -- 2018/10/24 tklua@wifiboy.org

# Encoding Converter https://r12a.github.io/app-encodings/

def b5offset(x):
    x1 = x >> 8
    x2 = x %256
    n=(x1-161)*2826+148
    if (x2<127):n+=(x2-64)*18
    else: n+=(x2-98)*18
    return n

def gboffset(x):
    x1=x>>8
    x2=x%256
    n=(x1-161)*94*18+(x2-161)*18+120
    return n

def jisoffset(x):
    x1=x>>8
    x2=x%256
    n=(x1-33)*94*18+(x2-33)*18+120
    return n

def kscoffset(x):
    x1=x>>8
    x2=x%256
    n=(x1-161)*94*18+(x2-161)*18+128
    return n

def showch(b, x, y, c):
    count = 0
    cx=x
    for i in range(18):
        for j in range(4):
            if b[i]&(2**(7-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
        for j in range(4):
            if b[i]&(2**(3-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
    
def showb5(s, x, y, c):
    with open("/sd/font/FB512F.PDB","rb") as f:
        for ch in s:
            f.seek(b5offset(ch))
            showch(f.read(18), x, y, c)
            x += 14
        f.close()
    
def showgb(s, x, y, c):
    with open("/sd/font/FGB12F.PDB","rb") as f:
        for ch in s:
            f.seek(gboffset(ch))
            showch(f.read(18), x, y, c)
            x += 14
        f.close()

def showjis(s, x, y, c):
    with open("/sd/font/FJIS12F.PDB","rb") as f:
        for ch in s:
            f.seek(jisoffset(ch))
            showch(f.read(18), x, y, c)
            x += 14
        f.close()
        
def showksc(s, x, y, c):
    with open("/sd/font/FKSC12F.PDB","rb") as f:
        for ch in s:
            f.seek(kscoffset(ch))
            showch(f.read(18), x, y, c)
            x += 14
        f.close()

wb.cls()
wb.str("CJK Fonts", 15,10,4,1)
    
b5str = [0xB0DD,0xA4D1,0xA455,0xBDD6,0xBB50,0xAAA7,0xBE57]
showb5(b5str, 15, 35, wb.WHITE)
   
gbstr=[0xCDF2,0xCEEF,0xBEB2,0xB9DB,0xBDD4,0xD7D4,0xB5C3]
showgb(gbstr, 15, 55, wb.YELLOW)

jisstr = [0x3835,0x3524,0x244A,0x3B51,0x382B,0x243F,0x2424]            
showjis(jisstr, 15, 75, wb.CYAN)

kscstr=[0xB9CC,0xBCBC,0xB8D5,0xC1F6,0xC0C7,0xB0E8,0xC0FD]
showksc(kscstr, 15, 95, wb.GREEN)
